﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerAnimation : MonoBehaviour
{
    private void OnHideAnimationComplete()
    {
        //Animation complete, confirm the location
        SpriteRenderer renderer = gameObject.GetComponent<SpriteRenderer>();
        renderer.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        GameController.Instance.ConfirmHideLocation();
    }

    private void OnRevealAnimationComplete()
    {
        //We've been revealed, let's reset the hidable and notify we've stopped revealing
        SpriteRenderer renderer = gameObject.GetComponent<SpriteRenderer>();
        renderer.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);

        GameController.Instance.HidingObject.GetComponent<HidableController>().ResetHidable();

        if (((SeekingPhase)GameController.Instance.CurrentGamePhase).TimeRemaining > 0.0f)
        {
            //Seeker found the hider as we still have time, so they'll celebrate
            GameController.Instance.SeekerPlayerObject.GetComponent<Animator>().Play("Celebrate", -1, 0.0f);
            GameController.Instance.HiderPlayerObject.GetComponent<Animator>().Play("Defeat", -1, 0.0f);
        }

        else
        {
            //There was no time left so the hider wasn't found, so they'll celebrate
            GameController.Instance.HiderPlayerObject.GetComponent<Animator>().Play("Celebrate", -1, 0.0f);
            GameController.Instance.SeekerPlayerObject.GetComponent<Animator>().Play("Defeat", -1, 0.0f);
        }

        if(AudioManager.Instance != null)
        {
            if(AudioManager.Instance.CelebrationAudio != null)
            {
                AudioManager.Instance.PlaySFX(AudioManager.Instance.CelebrationAudio);
            }

            if (AudioManager.Instance.DefeatAudio != null)
            {
                AudioManager.Instance.PlaySFX(AudioManager.Instance.DefeatAudio);
            }
        }
    }

    private void OnCelebrationAnimationComplete()
    {
        GameController.Instance.SeekerPlayerObject.GetComponent<SeekerController>().IsRevealing = false;    //The entire reveal process has finished

        //Celebrations are over, time to end the round
        if (((SeekingPhase)GameController.Instance.CurrentGamePhase).TimeRemaining > 0.0f)
        {
            //There was time remaining so the seeker won
            GameController.Instance.EndCurrentRound(Constants.PlayerRole.Seeker);
        }

        else
        {
            //There was no time left so the hider wasn't found and they won
            GameController.Instance.EndCurrentRound(Constants.PlayerRole.Hider);
        }
    }
}